#ifndef	_NEW_COMMON_H_
#define	_NEW_COMMON_H_

#define	NO						0
#define	YES						1

#define	OFF						0
#define	ON						1

#ifndef	NULL
	#define	NULL				0
#endif

#ifndef	FALSE
	#define	FALSE				0
#endif
#ifndef	TRUE
	#define	TRUE				1
#endif

#define	SYSTEM_PC_COUNT							1
#define	SYSTEM_HCB_COUNT						1
#define SYSTEM_TPB_COUNT						1

#define	SYSTEM_SPB_COUNT				        	    8
#define	SYSTEM_SPB_MAX_COUNT				          8
#define	SYSTEM_SPB_CAMERA_COUNT			        	4
#define	SYSTEM_SPB_CAMERA_MAX_COUNT				  	4

#define	SYSTEM_CPB_COUNT					          32
#define	SYSTEM_CPB_MAX_COUNT					      32
#define	SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT		8

// 3D ī޶ SPB ȮεǴ ƴ Ǵϴµ ̿
#define SUCTION_DISK_NONE 0
#define SUCTION_DISK_NUM1 1
#define SUCTION_DISK_NUM2 2
////// end

#define	SYSTEM_TOTAL_CAMERA_COUNT				    10

#define	SYSTEM_TOTAL_LED_COUNT					12
#define	SYSTEM_MACHINE_CAPTURE_COUNT			6

#define	SYSTEM_CAMERA_WIDTH						640
#define	SYSTEM_CAMERA_HEIGHT					480

#define	SYSTEM_CAMERA_WIDTH_3D					512
#define	SYSTEM_CAMERA_HEIGHT_3D					360

#define	IMAGE_WIDTH_3D							320
#define	IMAGE_HEIGHT_3D							480

#define	IMAGE_WIDTH_2D							640
#define	IMAGE_HEIGHT_2D							480


/************************************************************************************/
/* 	Bit	а   												*/
/************************************************************************************/

#define	BIT32_GET(VAR,FIELD) (unsigned int)( \
  	(VAR&##FIELD##_MASK)>>##FIELD##_SHIFT \
)

#define	BIT32_SET(VAR,FIELD,Val) VAR=(unsigned int)( \
  	(VAR&~##FIELD##_MASK)|(((unsigned int)(Val)<<##FIELD##_SHIFT)&##FIELD##_MASK) \
)

#define	BIT16_GET(VAR,FIELD) (unsigned short)( \
  	(VAR&##FIELD##_MASK)>>##FIELD##_SHIFT \
)

#define	BIT16_SET(VAR,FIELD,Val) VAR=(unsigned short)( \
  	(VAR&~##FIELD##_MASK)|(((unsigned short)(Val)<<##FIELD##_SHIFT)&##FIELD##_MASK)	\
)

#define	BIT8_GET(VAR,FIELD)	(unsigned char)( \
  	(VAR&##FIELD##_MASK)>>##FIELD##_SHIFT \
)

#define	BIT8_SET(VAR,FIELD,Val)	VAR=(unsigned char)( \
  	(VAR&~##FIELD##_MASK)|(((unsigned char)(Val)<<##FIELD##_SHIFT)&##FIELD##_MASK) \
)

#define	BOARD_ID_PC				0x8000
#define	BOARD_ID_PCI			0x4000
#define	BOARD_ID_HCB(s)			((s	& 0x03)	<< 13)	// s = 1 ~ 3
#define	BOARD_ID_SPB(s)			((s	& 0x3F)	<< 6)	// s = 1 ~ 31
#define	BOARD_ID_CPB(c)			(c & 0x3F)			// c = 1 ~ 31
#define	BOARD_ID_SPB_CPB(s,	c)	(((s) << 6)	+ (c))	// s, c	= 1	~ 31

// program ID for flash
#define	PROGRAMINFO_PROGRAMKIND_MONITOR			(('M' << 8)	| 'O')	///	4D00 | 004F	= 4D4F(01001101	01001111)
#define	PROGRAMINFO_PROGRAMKIND_APPLICATION_4		(('A' << 8)	| '4')
#define	PROGRAMINFO_PROGRAMKIND_APPLICATION_TABLET_5		(('A' << 8)	| '2')
#define	PROGRAMINFO_PROGRAMKIND_APPLICATION_CAPSULE_5		(('A' << 8)	| '3')

#define	PROGRAMINFO_BOARDKIND_HCB				'H'
#define	PROGRAMINFO_BOARDKIND_SPB				'S'
#define	PROGRAMINFO_BOARDKIND_CPB				'C'
#define	PROGRAMINFO_BOARDKIND_TPB				'T'

#define	PID_BOOT_RECORD		(('B' << 16) | ('0'	<< 8) |	'0')

#define	PID_HCB_MONITOR		((PROGRAMINFO_BOARDKIND_HCB	<< 16) | PROGRAMINFO_PROGRAMKIND_MONITOR)
#define	PID_HCB_APPLICATION_ALL_4	PID_HCB_MONITOR
#define	PID_HCB_APPLICATION_TABLET_5	((PROGRAMINFO_BOARDKIND_HCB	<< 16) | PROGRAMINFO_PROGRAMKIND_APPLICATION_TABLET_5)
#define	PID_HCB_APPLICATION_CAPSULE_5	((PROGRAMINFO_BOARDKIND_HCB	<< 16) | PROGRAMINFO_PROGRAMKIND_APPLICATION_CAPSULE_5)

#define	PID_SPB				(PROGRAMINFO_BOARDKIND_SPB << 16)
#define	PID_HCB				(PROGRAMINFO_BOARDKIND_HCB << 16)
#define	PID_CPB				(PROGRAMINFO_BOARDKIND_CPB << 16)
#define	PID_TPB				(PROGRAMINFO_BOARDKIND_TPB << 16)

#define	PID_TPB_TABLET	  	(PID_TPB | ('0'	<< 8) |	'0')
#define	PID_TPB_CAPSULE	  	(PID_TPB | ('1'	<< 8) |	'0')

#define	PID_SPB_TABLET_4	  	(PID_SPB | ('0'	<< 8) |	'0')
#define	PID_SPB_CAPSULE_4	  	(PID_SPB | ('1'	<< 8) |	'0')
#define	PID_SPB_TABLET_5   		(PID_SPB | ('2'	<< 8) |	'0')
#define	PID_SPB_CAPSULE_5  		(PID_SPB | ('3'	<< 8) |	'0')

#define	PID_CPB_TABLET_4	  	(PID_CPB | ('0'	<< 8) |	'0')
#define	PID_CPB_CAPSULE_4	  	(PID_CPB | ('1'	<< 8) |	'0')
#define	PID_CPB_TABLET_5	  	(PID_CPB | ('2'	<< 8) |	'0')
#define	PID_CPB_CAPSULE_5	  	(PID_CPB | ('3'	<< 8) |	'0')

/* 3.2 	PID	*/
#define	PID_HCB_DB_HEADER_T_3			(('D' << 24) | ('H'	<< 16) | ('T' << 8)	| '3')
#define	PID_SPB_DB_HEADER_T_3			(('D' << 24) | ('H'	<< 16) | ('T' << 8)	| '3')
#define	PID_HCB_MS_HEADER_T_3			(('M' << 24) | ('H'	<< 16) | ('T' << 8)	| '3')
#define	PID_SYSTEM_T_3		  			(('S' << 24) | ('S'	<< 16) | ('T' << 8)	| '3')
#define	PID_ENVIRONMENT_T_3				(('E' << 24) | ('V'	<< 16) | ('T' << 8)	| '3')
#define	PID_PORT_MAP_T_3			  	(('P' << 24) | ('M'	<< 16) | ('T' << 8)	| '3')
#define	PID_MACHINE_INFO_T_3  	  	(('M' << 24) | ('I'	<< 16) | ('T' << 8)	| '3')
#define	PID_USER_MACHINE_ENV_T_3	  (('U'	<< 24) | ('E' << 16) | ('T'	<< 8) |	'3')
#define	PID_RANGER_CAMERA_BASE_T_3	(('R' << 24) | ('B'	<< 16) | ('T' << 8)	| '3')
#define	PID_RANGER_CAMERA_T_3			(('R' << 24) | ('C'	<< 16) | ('T' << 8)	| '3')
#define	PID_TERMINATION_INFO_T_3  	(('T' << 24) | ('I'	<< 16) | ('T' << 8)	| '3')

/* 5.0 	PID	*/
#define	PID_HCB_DB_HEADER_T_5			(('D' << 24) | ('H'	<< 16) | ('T' << 8)	| '5')
#define	PID_SPB_DB_HEADER_T_5			(('D' << 24) | ('H'	<< 16) | ('T' << 8)	| '5')
#define	PID_HCB_MS_HEADER_T_5		(('M' << 24) | ('H'	<< 16) | ('T' << 8)	| '5')
#define	PID_SYSTEM_T_5					  (('S'	<< 24) | ('S' << 16) | ('T'	<< 8) |	'5')
#define	PID_ENVIRONMENT_T_5			  (('E'	<< 24) | ('V' << 16) | ('T'	<< 8) |	'5')
#define	PID_PORT_MAP_T_5				  (('P'	<< 24) | ('M' << 16) | ('T'	<< 8) |	'5')
#define	PID_MACHINE_INFO_T_5		(('M' << 24) | ('I'	<< 16) | ('T' << 8)	| '5')
#define	PID_USER_MACHINE_ENV_T_5	(('U' << 24) | ('E'	<< 16) | ('T' << 8)	| '5')
#define	PID_RANGER_CAMERA_BASE_T_5	(('R' << 24) | ('B'	<< 16) | ('T' << 8)	| '5')
#define	PID_RANGER_CAMERA_T_5		(('R' << 24) | ('C'	<< 16) | ('T' << 8)	| '5')
#define	PID_TERMINATION_INFO_T_5	(('T' << 24) | ('I'	<< 16) | ('T' << 8)	| '5')


/* 5.0 ĸ	PID	*/
#define	PID_HCB_DB_HEADER_C_5			(('D' << 24) | ('H'	<< 16) | ('C' << 8)	| '5')
#define	PID_SPB_DB_HEADER_C_5			(('D' << 24) | ('H'	<< 16) | ('C' << 8)	| '5')
#define	PID_HCB_MS_HEADER_C_5			(('M' << 24) | ('H'	<< 16) | ('C' << 8)	| '5')
#define	PID_SYSTEM_C_5				(('S' << 24) | ('S'	<< 16) | ('C' << 8)	| '5')
#define	PID_ENVIRONMENT_C_5			(('E' << 24) | ('V'	<< 16) | ('C' << 8)	| '5')
#define	PID_PORT_MAP_C_5			(('P' << 24) | ('M'	<< 16) | ('C' << 8)	| '5')
#define	PID_MACHINE_INFO_C_5		(('M' << 24) | ('I'	<< 16) | ('C' << 8)	| '5')
#define	PID_USER_MACHINE_ENV_C_5	(('U' << 24) | ('E'	<< 16) | ('C' << 8)	| '5')
#define	PID_RANGER_CAMERA_BASE_C_5	(('R' << 24) | ('B'	<< 16) | ('C' << 8)	| '5')
#define	PID_RANGER_CAMERA_C_5		(('R' << 24) | ('C'	<< 16) | ('C' << 8)	| '5')
#define	PID_TERMINATION_INFO_C_5	(('T' << 24) | ('I'	<< 16) | ('C' << 8)	| '5')


#ifdef VER5
	#ifdef PID_TYPE_CAPSULE
		#define	PID_HCB_DB_HEADER				PID_HCB_DB_HEADER_C_5
		#define	PID_SPB_DB_HEADER				PID_SPB_DB_HEADER_C_5
		#define	PID_HCB_MS_HEADER				PID_HCB_MS_HEADER_C_5
		#define	PID_SYSTEM					  	PID_SYSTEM_C_5
		#define	PID_ENVIRONMENT					PID_ENVIRONMENT_C_5
		#define	PID_PORT_MAP				  	PID_PORT_MAP_C_5
		#define	PID_MACHINE_INFO				PID_MACHINE_INFO_C_5
		#define	PID_USER_MACHINE_ENV		  PID_USER_MACHINE_ENV_C_5
		#define	PID_RANGER_CAMERA_BASE	  	PID_RANGER_CAMERA_BASE_C_5
		#define	PID_RANGER_CAMERA				PID_RANGER_CAMERA_C_5
		#define	PID_TERMINATION_INFO	  	PID_TERMINATION_INFO_C_5
	#else
		#define	PID_HCB_DB_HEADER				PID_HCB_DB_HEADER_T_5
		#define	PID_SPB_DB_HEADER				PID_SPB_DB_HEADER_T_5
		#define	PID_HCB_MS_HEADER				PID_HCB_MS_HEADER_T_5
		#define	PID_SYSTEM					  	PID_SYSTEM_T_5
		#define	PID_ENVIRONMENT					PID_ENVIRONMENT_T_5
		#define	PID_PORT_MAP			  		PID_PORT_MAP_T_5
		#define	PID_MACHINE_INFO				PID_MACHINE_INFO_T_5
		#define	PID_USER_MACHINE_ENV	  	PID_USER_MACHINE_ENV_T_5
		#define	PID_RANGER_CAMERA_BASE	  	PID_RANGER_CAMERA_BASE_T_5
		#define	PID_RANGER_CAMERA				PID_RANGER_CAMERA_T_5
		#define	PID_TERMINATION_INFO	  	PID_TERMINATION_INFO_T_5
	#endif
#else
	#define	PID_HCB_DB_HEADER			 PID_HCB_DB_HEADER_T_3
	#define	PID_SPB_DB_HEADER			 PID_SPB_DB_HEADER_T_3
	#define	PID_HCB_MS_HEADER			 PID_HCB_MS_HEADER_T_3
	#define	PID_SYSTEM					   PID_SYSTEM_T_3
	#define	PID_ENVIRONMENT				 PID_ENVIRONMENT_T_3
	#define	PID_PORT_MAP				   PID_PORT_MAP_T_3
	#define	PID_MACHINE_INFO			 PID_MACHINE_INFO_T_3
	#define	PID_USER_MACHINE_ENV	   PID_USER_MACHINE_ENV_T_3
	#define	PID_RANGER_CAMERA_BASE	 PID_RANGER_CAMERA_BASE_T_3
	#define	PID_RANGER_CAMERA			 PID_RANGER_CAMERA_T_3
	#define	PID_TERMINATION_INFO	   PID_TERMINATION_INFO_T_3
#endif // end if VER5

#define	PROJECT_ID_ELMA_100		(('E' << 24) | ('M'	<< 16) | ('1' << 8)	| '0')
#define	PROJECT_NAME_ELMA_100	"SELMA150T"
#define	HCB_PROGRAM_REV			106
#define	SPB_PROGRAM_REV			105

/* Error type */
#define	ERROR_TYPE_CRITICAL			0x0100
#define	ERROR_TYPE_WARNING			0x0200
#define	ERROR_TYPE_MESSAGE			0x0300
#define	ERROR_TYPE_DEBUG			0x0400
#define	ERROR_TYPE_USER_NOTIFY		0x0500

/************************************************************************************/
/* Error Code																		*/
/************************************************************************************/
typedef	unsigned int TErrorCode;

#define	ERROR_CODE_NONE							0x00000000

// 	 
#define	ERROR_CODE_CHECKSUM						0x00000002
#define	ERROR_CODE_ALREADY_PACKET				0x00000007
#define	ERROR_CODE_WRONG_SIZE					0x00000008
// ProcessUnit 	
#define	ERROR_CODE_NOTMATCH						0x00000083
//   	
#define	ERROR_CODE_OVERFLOW						0x00000106
#define	ERROR_CODE_FLASH_OPEN					0x00000200
#define	ERROR_CODE_FLASH_READ					0x00000201
#define	ERROR_CODE_FLASH_WRITE					0x00000202
#define	ERROR_CODE_ENVIRONMENT_NOT_MATCH		0x00000203
#define	ERROR_CODE_TIMER_OVERLAP				0x00000204
// MCBSP error
#define	ERROR_CODE_MCBSP_WRONG_SIZE				0x00000300
#define	ERROR_CODE_MCBSP_MULTIPLE_RESPONSE		0x00000301
#define	ERROR_CODE_MCBSP_TX_NOT_EMPTY			0x00000302
#define	ERROR_CODE_MCBSP_TX_CANNOT_WRITE		0x00000303
#define	ERROR_CODE_MCBSP_TRANSMIT_TIMEOUT		0x00000304
#define	ERROR_CODE_MCBSP_BUFFER_OVERFLOW		0x00000306
#define	ERROR_CODE_MCBSP_RETRY_COUNT_OVER		0x00000307
// HPI error
#define	ERROR_CODE_HPI_CPB_INT_STATE			0x00000400
#define	ERROR_CODE_HPI_READ_TIMEOUT				0x00000401
#define	ERROR_CODE_HPI_RETRY_EXCEEDED			0x00000402
#define	ERROR_CODE_HPI_RLI_TIMEOUT				0x00000403
#define	ERROR_CODE_HPI_SI_TIMEOUT				0x00000404
#define	ERROR_CODE_HPI_SLI_TIMEOUT				0x00000405
#define	ERROR_CODE_HPI_RECEIVE					0x00000406

// capture error
#define	ERROR_CODE_CAPTURE_TIMEOUT				0x00000500
#define	ERROR_CODE_CAPTURE_UNWANTED_INT			0x00000501
#define	ERROR_CODE_CAPTURE_JOB_FULL				0x00000502
#define	ERROR_CODE_CAPTURE_DMA_TABLE_OVERFLOW	0x00000503
#define	ERROR_CODE_CAPTURE_OVERFLOW				0x00000504

// cpb process error
#define	ERROR_CODE_CPB_BOARD_DOWN				0x00000600
#define	ERROR_CODE_CPB_PROCESS_TIMEOUT			0x00000601

#define	ERROR_CODE_PROCESS_RUNTIME				0x00000700
#define	ERROR_CODE_PROCESS_WRONG_RESULT			0x00000701

// usb error
#define	ERROR_CODE_USB_EP0_STALL				0x00000800

// hcb
#define	ERROR_CODE_SERVO_NAK					0x00100700
#define	ERROR_CODE_SERVO_ALRAM					0x00100701
#define	ERROR_CODE_SERVO_COM_TIMEOUT			0x00100702
#define	ERROR_CODE_SERVO_WRONG_CODE				0x00100703

#define	ERROR_CODE_STEPMOTOR_BUSY				0x00100800

// user	notify error
#define	ERROR_CODE_FEEDER_POS_NOT_READY			0x00000001
#define	ERROR_CODE_FEEDER_NOT_STOP				0x00000002
#define	ERROR_CODE_MACHINE_NOT_STOP				0x00000003
#define	ERROR_CODE_MACHINE_NOT_READY			0x00000004


/************************************************************************************/
/* StatusList 																	*/
/************************************************************************************/
#define	MACHINE_STATE_STOP							0
#define	MACHINE_STATE_RUN							1
#define	MACHINE_STATE_CLEANING						2
#define	MACHINE_STATE_ATTACHING						3
#define	MACHINE_STATE_DETACHING						4
#define	MACHINE_STATE_STARTING						5
#define	MACHINE_STATE_STOPPING						6
//#define MACHINE_STATE_SUSPEND						7
#define	MACHINE_STATE_EMERGENCY_STOP				8

#define	MACHINE_SUSPEND_REASON_FEEDER_EMPTY			0
#define	MACHINE_SUSPEND_REASON_FEEDER_TROUBLE		1
#define	MACHINE_SUSPEND_REASON_DEFECT				2
#define	MACHINE_SUSPEND_REASON_UNINSPECT			3
#define	MACHINE_SUSPEND_REASON_TIMEOUT				4
#define	MACHINE_SUSPEND_REASON_TABLET_DISAPPEAR		5
#define	MACHINE_SUSPEND_REASON_REGULATOR			6
#define	MACHINE_SUSPEND_REASON_BLOWER_OL			7
#define	MACHINE_SUSPEND_REASON_VD1_STALL			8
#define	MACHINE_SUSPEND_REASON_VD2_STALL			9
#define	MACHINE_SUSPEND_REASON_GP_COUNT_REACHED		10
#define	MACHINE_SUSPEND_REASON_BRIGHTNESS_DOWN		11
#define	MACHINE_SUSPEND_REASON_DOOR_OPEN			12
#define	MACHINE_SUSPEND_REASON_DP_COUNT_REACHED		13
#define	MACHINE_SUSPEND_REASON_UP_COUNT_REACHED		14
#define	MACHINE_SUSPEND_REASON_VISION_SENSOR_1		15
#define	MACHINE_SUSPEND_REASON_VISION_SENSOR_2		16
#define	MACHINE_SUSPEND_REASON_TIME_OVER			17

#define	MACHINE_EMERGENCY_REASON_USER_SWITCH		0
#define	MACHINE_EMERGENCY_REASON_REGULATOR_LOW		1
#define	MACHINE_EMERGENCY_REASON_RINGBLOWER			2

#define	SL_CPB_PROCESSING_SHIFT			11				// CPB's image processing status (2	bit)
#define	SL_CPB_PROCESSING_MASK			0x00001800

#define	SL_CPB_PROCESSING_READY			  0
#define	SL_CPB_PROCESSING_SENDDATA		1
#define	SL_CPB_PROCESSING_RUNNING		  2
#define	SL_CPB_PROCESSING_FINISHED		3

//************************************************************************************/
// Etc                                                                               */
//************************************************************************************/
#define	CAPTURE_MODE_NONE					    0x000
#define	CAPTURE_MODE_DEFAULT				  0x001
#define	CAPTURE_MODE_FRAME					  0x002
//#define CAPTURE_MODE_PROCESSING			0x004
#define	CAPTURE_MODE_CONTINUOUS				0x010
#define	CAPTURE_MODE_PARTIAL				  0x020
#define	CAPTURE_MODE_MACHINE_CAPTURE	0x100

#define	CAPTURE_TYPE_NONE				      0
#define	CAPTURE_TYPE_SINGLE_CAPTURE		1
#define	CAPTURE_TYPE_FULL_CAPTURE		  2
#define	CAPTURE_TYPE_PROCESSING			  3

#define	CAPTURE_KIND_FRAME				    0
#define	CAPTURE_KIND_LINE				      1

#define	HCB_SPB_COMPATIBILITY_SPB04		0
#define	HCB_SPB_COMPATIBILITY_SPB06		1

#define	SPB_BOARD_KIND_SPB04			0
#define	SPB_BOARD_KIND_SPB06			1

#define	CPB_CPU_CLOCK_KIND_900						0
#define	CPB_CPU_CLOCK_KIND_1100						1

#define	SPB_IMAGE_TRANSFER_METHOD_CHECKSUM			0
#define	SPB_IMAGE_TRANSFER_METHOD_NO_CHECKSUM		1

#define	CAMERA_KIND_CIS							          0
#define	CAMERA_KIND_RANGER_3D					        1
#define CAMERA_KIND_NFA_2D				            2
#define	CAMERA_KIND_NFA_3D				            3
		
#define	CAMERA_DISCONNECTION				    0
#define	CAMERA_CONNECTION				        1

#define	CAMERA_POSITION_FRONT_FACE				    0
#define	CAMERA_POSITION_FRONT_FACE_BACKLIGHT	1
#define	CAMERA_POSITION_SIDE_FACE_M45			    2
#define	CAMERA_POSITION_SIDE_FACE_0				    3
#define	CAMERA_POSITION_SIDE_FACE_P45			    4
#define	CAMERA_POSITION_3D						        5
#define	CAMERA_POSITION_DISCONNECT				    6

#define	CPB_STATUS_DISABLED			0
#define	CPB_STATUS_BOOT_READY		1
#define	CPB_STATUS_BOOTING			2
#define	CPB_STATUS_IDLE				  3
#define	CPB_STATUS_PROCESSING		4

#define	MAX_SERVO_MOTOR_COUNT		5

#define	SD1_MOTOR_INDEX				0
#define	SD2_MOTOR_INDEX				1
#define	BF_ID_MOTOR_INDEX			2
#define 	BF_OD_IN_MOTOR_INDEX			3
#define 	BF_OD_OUT_MOTOR_INDEX			4

#define	MAX_STEP_MOTOR_COUNT			5

#define	BF_UP_DOWN_MOTOR_INDEX			0
#define	BF_IN_OUT_MOTOR_INDEX			  1
#define	VG1_UP_DOWN_MOTOR_INDEX			2
#define	VG2_UP_DOWN_MOTOR_INDEX			3
#define	SD2_LEFT_RIGHT_MOTOR_INDEX	4

#define	NC_POS_PARAM_1_MUL					(2000)
#define	NC_POS_PARAM_2_MUL					(2000)
#define	NC_POS_PARAM_3_MUL					(2000)
#define	NC_POS_PARAM_4_MUL					(2000)
#define	NC_POS_PARAM_5_MUL					(2000)

#define	NC_POS_PARAM_1_DIV					(-4)
#define	NC_POS_PARAM_2_DIV					(-3)
#define	NC_POS_PARAM_3_DIV					(2)
#define	NC_POS_PARAM_4_DIV					(2)
#define	NC_POS_PARAM_5_DIV					(3)

#define	MACHINE_LAMP_KIND_DISCONNECTED					  0
#define	MACHINE_LAMP_KIND_NORMAL_TABLET					  1
#define	MACHINE_LAMP_KIND_SUGAR_COATED_TABLET			2
#define	MACHINE_LAMP_KIND_NORMAL_CAPSULE				  3

#define	MAX_SPEED_TRAINING_MODE_MANUAL		0
#define	MAX_SPEED_TRAINING_MODE_AUTO		  1

#define	MACHINE_MODE_TEST			    0
#define	MACHINE_MODE_FREE			    1
#define	MACHINE_MODE_INTERLOCK		2
#define	MACHINE_MODE_PROTECTED		3

#define	PC_POWER_MODE_MANUAL	0
#define	PC_POWER_MODE_AUTO		1

#define	MAX_OP_TEST_COUNT				16

#define	TC_TABLE_CAPACITY		256		// 	interval, ʴ ִ	ν   Ѵ.

#define	SYSTEM_MAX_THERMOMETER_COUNT			  3
#define	SYSTEM_MAX_PRESSURE_METER_COUNT			3
#define	SYSTEM_MAX_INVERTER_COUNT				    3

#define	RS485_UNIT_COUNT				8

#define	HCB_TABLET_LIST_COUNT			256		// must	be power of	2
#define	HCB_TABLET_LIST_MASK			255		// HCB_TABLET_LIST_COUNT - 1
#define	MIN_TABLET_INTERVAL				15

#define	SENSOR_STATE_NOT_PASSED			0
#define	SENSOR_STATE_PASSED				  1

#define	TABLET_STATE_READY						            0
#define	TABLET_STATE_SENSOR_1_PASSED			        1
#define	TABLET_STATE_CAPTURE_INT_1_TRANSFERRED	  2
#define	TABLET_STATE_CAPTURE_1_COMPLETE			      3
#define	TABLET_STATE_SENSOR_2_PASSED			        4
#define	TABLET_STATE_CAPTURE_INT_2_TRANSFERRED	  5
#define	TABLET_STATE_RESULT_WAITING				        6
#define	TABLET_STATE_BLOW_WAITING				          7
#define	TABLET_STATE_NC_WAITING					          8
#define	TABLET_STATE_COMPLETE					            9
#define	TABLET_STATE_ERROR						            0xFF

#define	TABLET_RESULT_NONE									              0
#define	TABLET_RESULT_GOOD									              1
#define	TABLET_RESULT_DEFECT								              2
#define	TABLET_RESULT_DEFECT_UNPRINT						          3
#define	TABLET_RESULT_DEFECT_SPB_PROCESSING_NOT_COMPLETE	4
#define	TABLET_RESULT_UNINS_SPB_TIMEOUT						        5
#define	TABLET_RESULT_UNINS_SPB_PROCESSING_NOT_COMPLETE		6
//#define TABLET_RESULT_UNINS_FROM_SPB						        7
#define	TABLET_RESULT_INSERTED								            8
#define	TABLET_RESULT_DISAPPEARED							            9
//#define TABLET_RESULT_SMALL_SIZE							          10
#define	TABLET_RESULT_EARLY									              11
#define	TABLET_RESULT_LATE									              12
//#define TABLET_RESULT_MISTAKEN							            13
#define	TABLET_RESULT_SENSOR_1_MISFEEDING					        13
#define	TABLET_RESULT_SENSOR_2_MISFEEDING					        14
#define	TABLET_RESULT_MULTI_TABLET_SENSOR_1					      15
#define	TABLET_RESULT_MULTI_TABLET_SENSOR_2					      16
#define	TABLET_RESULT_UNINTENDED_UNINSPECT					      17
#define	TABLET_RESULT_DEFECT_FR_MISMATCH					        18

#define	TABLET_RESULT_SPB_MASK								0x1000		// 4096

#define	IMAGE_STATE_EMPTY			    0
#define	IMAGE_STATE_ON_CAPTURE		1
#define	IMAGE_STATE_CAPTURED		  2
#define	IMAGE_STATE_PROCESSING		3
#define	IMAGE_STATE_DEFECT			  4
#define	IMAGE_STATE_UPLOADING		  5

#define	IMAGE_RESULT_NONE			    0
#define	IMAGE_RESULT_GOOD			    1
#define	IMAGE_RESULT_DEFECT			  2

#define	TABLET_EJECTION_NONE			  0
#define	TABLET_EJECTION_UNINSPECT		1
#define	TABLET_EJECTION_DEFECT			2

#define	TABLET_EJECTION_CHECK_NONE		0
#define	TABLET_EJECTION_CHECK_EMPTY		1
#define	TABLET_EJECTION_CHECK_EXIST		2

#define	RESULT_TABLE_SIZE				256
#define	RESULT_TABLE_MASK				255

#define	SPB_TABLET_STATE_NONE						        0
#define	SPB_TABLET_STATE_FINDING_BUFFER				  1
#define	SPB_TABLET_STATE_NUMBERING					    2
#define	SPB_TABLET_STATE_CAPTURE_READY				  3
#define	SPB_TABLET_STATE_ON_CAPTURE					    4
#define	SPB_TABLET_STATE_CAPTURED					      5
//#define SPB_TABLET_STATE_PROCESSING_READY			6
#define	SPB_TABLET_STATE_PROCESSING					    7
#define	SPB_TABLET_STATE_PROCESSING_COMPLETE		8
#define	SPB_TABLET_STATE_ERROR						      0xFF

#define	SPB_TABLET_RESULT_NONE								              0
#define	SPB_TABLET_RESULT_PROCESSING						            1
#define	SPB_TABLET_RESULT_GOOD								              2
#define	SPB_TABLET_RESULT_DEFECT							              3
#define	SPB_TABLET_RESULT_UNINS_IMAGE_BUFFER_FULL			      4
#define	SPB_TABLET_RESULT_UNINS_TABLET_NUMBER_UNDEFINED		  5
#define	SPB_TABLET_RESULT_UNINS_WRONG_TABLET_NUMBER			    6
#define	SPB_TABLET_RESULT_UNINS_CAPTURE_TIMEOUT				      7
#define	SPB_TABLET_RESULT_UNINS_CAPTURE_NOT_READY			      8
#define	SPB_TABLET_RESULT_UNINS_PROCESSING_TIMEOUT			    9
#define	SPB_TABLET_RESULT_UNINS_PROCESSING_ERROR			      10
#define	SPB_TABLET_RESULT_UNINS_CPB_FULL					          11
#define	SPB_TABLET_RESULT_UNINS_CLOSED_TABLET				        12
#define	SPB_TABLET_RESULT_UNINS_TABLET_POSITION				      13
#define	SPB_TABLET_RESULT_UNINS_BRIGHTNESS_DROPPED			    14
#define	SPB_TABLET_RESULT_UNINS_BRIGHTNESS_CHASE			      15
#define	SPB_TABLET_RESULT_PROCESSING_MASK					          0x0F
#define	SPB_TABLET_RESULT_PRINT_IS_MASK						          0x10
#define	SPB_TABLET_RESULT_PRINT_TYPE_MASK					          0x80
#define	SPB_TABLET_RESULT_FRONT_FACE_MASK					          0x20
//#define SPB_TABLET_RESULT_PRINT_MASK						          0x70
//#define SPB_TABLET_RESULT_PRINT_IS_CAM1					          0x10
//#define SPB_TABLET_RESULT_PRINT_IS_CAM2					          0x20
//#define SPB_TABLET_RESULT_PRINT_IS_CAM3					          0x40
#define	SPB_TABLET_RESULT_THICKERROR_MASK					          0x40

#define	SPB_TABLET_RESULT_PRINT_IS_SHIFT					    4
#define	SPB_TABLET_RESULT_PRINT_TYPE_SHIFT					  7
#define	SPB_TABLET_RESULT_FRONT_FACE_SHIFT					  5
#define	SPB_TABLET_RESULT_PRINT_THICKERROR_SHIFT			6

#define	TABLET_INSPECTION_STATE_NONE						      0
#define	TABLET_INSPECTION_STATE_CAPTURE_WAITING				1
#define	TABLET_INSPECTION_STATE_ON_CAPTURE					  2
#define	TABLET_INSPECTION_STATE_CAPTURED					    3
#define	TABLET_INSPECTION_STATE_PROCESSING_READY			4
#define	TABLET_INSPECTION_STATE_PROCESSING					  5
#define	TABLET_INSPECTION_STATE_PROCESSING_COMPLETE		6
#define	TABLET_INSPECTION_STATE_PASSED						    7
#define	TABLET_INSPECTION_STATE_CAPTURE_ERROR				  8
#define	TABLET_INSPECTION_STATE_PROCESSING_ERROR			9

#define	TABLET_PROCESSING_RESULT_UNKNOWN					          0
#define	TABLET_PROCESSING_RESULT_GOOD						            1
#define	TABLET_PROCESSING_RESULT_DEFECT						          2
#define	TABLET_PROCESSING_RESULT_ERROR						          3
#define	TABLET_PROCESSING_RESULT_CPB_FULL					          4
#define	TABLET_PROCESSING_RESULT_CLOSED_TABLET				      5
#define	TABLET_PROCESSING_RESULT_UNINS_TABLET_POSITION		  6
#define	TABLET_PROCESSING_RESULT_UNINS_BRIGHTNESS_DROPPED	  7
#define	TABLET_PROCESSING_RESULT_UNINS_BRIGHTNESS_CHASE		  8
#define	TABLET_PROCESSING_RESULT_THIN_TABLET				        9
#define	TABLET_PROCESSING_RESULT_FAT_TABLET					        10

#define	SPB_TABLET_LIST_COUNT			256
#define	SPB_TABLET_LIST_MASK			255

#define	RANGER_CAMERA_COMMAND_RESULT_NONE			      0
#define	RANGER_CAMERA_COMMAND_RESULT_OK				      1
#define	RANGER_CAMERA_COMMAND_RESULT_COM_TIMEOUT	  2
#define	RANGER_CAMERA_COMMAND_RESULT_COM_ERROR		  3

#define	TABLET_PROCESSING_MODE_NONE				          0
#define	TABLET_PROCESSING_MODE_CALIBRATION		      1
#define	TABLET_PROCESSING_MODE_STUDY			          2
#define	TABLET_PROCESSING_MODE_INSPECTION		        3

#define	MAX_TABLET_NUMBER			1000000000

#define	SPB_PROCESSING_RESULT_COUNT		8

#define	SPB_SETUP_MODE_STUDY				        0
#define	SPB_SETUP_MODE_INSPECTION			      1
#define	SPB_SETUP_MODE_GRADE_CHANGE			    2

#define	PROCESSING_SETUP_KIND_NONE			    0
#define	PROCESSING_SETUP_KIND_STUDY			    1
#define	PROCESSING_SETUP_KIND_INSPECTION	  2
#define	PROCESSING_SETUP_KIND_GRADE_CHANGE	3

#define	PROCESSING_SETUP_STEP_NONE			    0
#define	PROCESSING_SETUP_STEP_READY			    1
#define	PROCESSING_SETUP_STEP_WAITING		    2
#define	PROCESSING_SETUP_STEP_INIT			    3
#define	PROCESSING_SETUP_STEP_SETUP			    4
#define	PROCESSING_SETUP_STEP_COM_WAITING	  5
#define	PROCESSING_SETUP_STEP_CLEAR			    6
#define	PROCESSING_SETUP_STEP_COMPLETE		  7

#define	PROCESSING_SETUP_CPB_STEP_NONE		  0
#define	PROCESSING_SETUP_CPB_STEP_READY		  1
#define	PROCESSING_SETUP_CPB_STEP_COMPLETE	2
#define	PROCESSING_SETUP_CPB_STEP_FAIL		  3
#define	PROCESSING_SETUP_CPB_STEP_INVALID	  4

#define	VFINFO_LIST_COUNT		32
#define	VFINFO_LIST_MASK		31

#define	CPB_PROCESSING_TIME_LIST_COUNT		32

#define	CPB_REV_003							3
#define	CPB_REV_004							4

typedef	struct
{
	unsigned char CPBRevInfo[SYSTEM_MAX_SPB_CLIENT_BOARD_COUNT];
} TSPBSystemInfo;

#define	IDLE_PROCESS_LIST_COUNT		256
#define	IDLE_PROCESS_LIST_MASK		255

#define	ERROR_VALUE_MAX_SIZE			3			/* integer	 3			*/

////// For SELMA200, Add by moon. (20180208)
//Module1
#define SD1_2D_FRONT_FACE_CAMERA_INDEX            1
#define SD1_2D_SIDE_FACE_P45_CAMERA_INDEX         3
#define SD1_2D_SIDE_FACE_00_CAMERA_INDEX          4
#define SD1_2D_SIDE_FACE_M45_CAMERA_INDEX         5
#define SD1_3D_FRONT_FACE_CAMERA_INDEX            2
//Module2
#define SD2_2D_FRONT_FACE_CAMERA_INDEX            6
#define SD2_2D_SIDE_FACE_P45_CAMERA_INDEX         8
#define SD2_2D_SIDE_FACE_00_CAMERA_INDEX          9
#define SD2_2D_SIDE_FACE_M45_CAMERA_INDEX         10
#define SD2_3D_FRONT_FACE_CAMERA_INDEX            7
////// end

#define HALF_INSPECTION_CAMERA_INDEX  6 // Module  뵵 
#define HALF_CAPTURE_INDEX            3 // Module  뵵 


//---------------------------------------------------------------------------
#define FST_3D_CAMERA_SPB_INDEX 0
#define SEC_3D_CAMERA_SPB_INDEX 1

//------------------------------------------------------------
//******************* <  >   *******************
#define JPPRODUCT
/*
	KRPRODUCT // ѱ
	JPPRODUCT // Ϻ 
*/


typedef	struct
{
	unsigned int ProjectID;
	unsigned int ProgramRev;	// demands on program source code
	unsigned int reserved1[2];
	char ProjectName[16];
	char reserved2[32];
} THCBProgramHeader;		// common 64 bytes low-level header

typedef	struct
{
	unsigned int DataRev;	// demands on data structure
	unsigned int reserved1[3];
	char reserved2[16];
} THCBDBHeader;		// common 32 bytes low-level header

typedef	struct
{
	char MachineName[16];
} THCBMachineSpecificHeader;

typedef	struct
{
	unsigned int ProjectID;
	unsigned int ProgramRev;	// demands on program source code
	unsigned int reserved1[2];
	char ProjectName[16];
	char reserved2[32];
} TSPBProgramHeader;		// common 64 bytes low-level header

typedef	struct
{
	unsigned int DataRev;	// demands on data structure
	unsigned int reserved1[3];
	char reserved2[16];
} TSPBDBHeader;		// common 32 bytes low-level header

typedef	struct
{
	unsigned char VersionL;
	unsigned char VersionH;
	unsigned char reserved[2];
} TSPBFPGAVersion;

typedef	struct
{
	unsigned int BREnabled;
	unsigned int ProgramID;
	unsigned int Reserved[2];
} TBootRecord;

typedef	struct
{
	unsigned int MajorVersion;
	unsigned int MinorVersion;
	unsigned int Date;
	unsigned int Type;
} TProgramVersion;

typedef	struct
{
	unsigned char SPBCompatibility;
	unsigned char reserved[3];
} THCBCompatibility;

typedef	struct
{
	unsigned char TargetSPBBoardKind;
	unsigned char reserved[3];
	unsigned int CPBAlgMajorVersion;
	unsigned int CPBAlgMinorVersion;
  unsigned int CPBAlgTargetSystem;
  unsigned int CPBAlgReleaseDate;
} TSPBCompatibility;

typedef	struct
{
	unsigned int AlgMajorVersion;
	unsigned int AlgMinorVersion;
  unsigned int AlgTargetSystem;
  unsigned int AlgReleaseDate;
} TCPBCompatibility;

typedef	struct
{
	unsigned char SPBIndex;
	unsigned char CamIndex;
	unsigned short CameraInspectPosition;
} TCameraMapInfo;

typedef	struct
{
	int	DefaultCPBProgramID;
	unsigned char CPBEnabled[SYSTEM_CPB_MAX_COUNT];
	unsigned char CPBSDRSizeType[SYSTEM_CPB_MAX_COUNT];
	int	CameraDistributionIndex[SYSTEM_CPB_MAX_COUNT];
	unsigned char CameraHardwarePosition[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned char InspectPosition[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned short GlobalCameraIndex[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned char CameraKind[SYSTEM_SPB_CAMERA_MAX_COUNT];
	unsigned char CamMask;
	unsigned char reserved1[3];
	unsigned char CPBClockKind[SYSTEM_CPB_MAX_COUNT];
	TCameraMapInfo CameraMapInfo[SYSTEM_TOTAL_CAMERA_COUNT];		// save	camera map to every	spb	just for data matching
	unsigned char ImageTransferMethod;
	unsigned char reserved2[3];
    
	// khd1994 - TCP ּ  Ʈȣ
    	unsigned short nTcpPort;
    	char     szIpAddr[32];
} TSPBSystemSetupData;

typedef	struct
{
	unsigned char IsAutoScanMode;
	unsigned char Gain;
	unsigned char ThresholdCount;
	unsigned char OutputSelect;
	unsigned char Median;
	unsigned char Morphology;
	unsigned char MorphologySize;
	unsigned char reserved1[1];
	unsigned short ExposureTime2D;
	unsigned short ExposureTime3D;
	unsigned short LineScanTime;
	unsigned short StartCol;
	unsigned short ColCount;
	unsigned short StartRow;
	unsigned short RowCount;
	unsigned short Threshold1;
	unsigned short Threshold2;
	unsigned short reserved2[1];
} TRanger3DCameraInfo; // 20180208 For SELMA200, 

typedef	struct
{	
	int	SDRSizeType;
	int	SuctionDiskNumber;
	int bCameraConnection;
}
TCPBSystemSetupData;

typedef	struct
{
	unsigned char Enabled;
	unsigned char IsDown;
	unsigned char Status;
	unsigned char reserved;
} TCPBStatus;

typedef	struct
{
	char WarningExist;
	char HopperEmpty;
	char DefectBinFull;
	char UnInsBinFull;
	char RegulatorWarning;
	char FrontDoorOpen;
	char LeftDoorOpen;
	char RightDoorOpen;
	char BowlFeederSensorDisconnected;
	char SuctionDisk1LampDisconnected;
	char SuctionDisk2LampDisconnected;
	char EjectorDisconnected;
} TMachineWarningState;

typedef	struct
{
	char AlarmExist;
	char RegulatorError;
	char EmergencyOn;
	char Inverter1Trip;
	char Inverter2Trip;
	char RingBlower3OL;
	char Disk1SuctionLow;
	char Disk2SuctionLow;
	char ServoAlarm;
	char Interlock;
	char Disk1Stall;
	char Disk2Stall;
	char GPFull;
	char DPFull;
	char UPFull;
	char DPRatioOver;
	char UPRatioOver;
	char CritUPRatioOver;
	char Sensor1Error;
	char Sensor2Error;
	char BrightnessDown;
	char StepMotorStall[MAX_STEP_MOTOR_COUNT];
  char EmissionSensorOn;
	char reserved[1];
	char CheckMisEjector;
    char CheckDistributor;   // й.
  char MESCall; // MES RS232   
} TMachineAlarmState;

typedef	struct
{
	char AlarmExist;
	char GPFull;
	char DPFull;
	char UPFull;
	char DPRatioOver;
	char UPRatioOver;
	char CritUPRatioOver;
	char Sensor1Error;
	char Sensor2Error;
	char BrightnessDown;
	char Timeout;
	char dummy[1];
	char MisEjecMultiAction;
    char DistributorDown;    // й
} TInspectionAlarmState;

typedef	struct
{
	int	BaseSpeed;
	int	AccTime;
	int	DecTime;
	int	Dir;
} TServoMotorData;

typedef	struct
{
	int	Activated;
	int	SensingTime;
	int	Ejector1Delay;
	int	Ejector1RunTime;
	int	Ejector2Delay;
	int	Ejector2RunTime;
	int	GuideInTime;
	int	GuideOutTime;
} TRecoveryInfo1;

typedef	struct
{
	int	Activated;
	int	SensingTime;
	int	Ejector1Delay;
	int	Ejector1RunTime;
	int	Ejector2Delay;
	int	Ejector2RunTime;
	int	FeederStopTime;
	int	ReverseMoveAccTime;
	int	ReverseMoveSpeed;
	int	ReverseMoveRunTime;
} TRecoveryInfo2;

typedef	struct
{
	int	Activated;
	int	SensingTime;
	int	FeederStopTime;
	int	ForceMoveAccTime;
	int	ForceMoveSpeed;
	int	ForceMoveRunTime;
} TRecoveryInfo3;

typedef	struct
{
	int	CaptureDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
	int	IlluminatorMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	int	IlluminatorDelay[SYSTEM_MACHINE_CAPTURE_COUNT];
	int	IlluminatorTime[SYSTEM_MACHINE_CAPTURE_COUNT];
	int	CamMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	int	SensorSPBMask[2];
} TMachineCaptureInfo;

typedef	struct
{
	int	DefectEjectorDelay;
	int	DefectSolDelay;
	int	DefectSolMinTime;
	int	DefectSolInterval1;
	int	DefectSolInterval2;
	int	UnInsEjectorDelay;
	int	UnInsSolDelay;
	int	UnInsSolMinTime;
	int	UnInsSolInterval1;
	int	UnInsSolInterval2;
	int	MisejectActive;
	int	MisejectDelay;
	int	MisejectRunTime;
	int	MisejectActiveDelay;
	int	DefStartDelay;
	int	UninsStartDelay;
	int	Special_InspectionActive;
	int	Blowinterval;
	int	Blowstart;
	int	Blowlength;
	int	UninsBlowCheck;
  int EjectorWindStrength;
  int EjectorDefaultMode;//̴ȣ

  int DistributorGoodTabletCount1;
  int DistributorGoodTabletCount2;
} TEjectorInfo;

typedef	struct
{
	int	EmptySensorActiveRatio;
	int	FullSensorActiveRatio;
	int	StartSpeed;
	int	MaxSpeedTrainingMode;

	int	ManualMaxSpeed;
	int	ManualModeSensorIndex;
	int	ManualModeSensorActiveRatio;
	int	ManualLimitSpeed;
	int	ManualModeLimitSensorIndex;
	int	ManualModeLimitSensorActiveRatio;
	int	MechanicalMinSpeed;
	int	MechanicalMaxSpeed;
} TVibrationFeederInfo;

typedef	struct
{
	int	DoorInterlockEnabled;
	int	NCInterlockAValue;
} TInterlockInfo;

typedef	struct
{
	unsigned short BuzzerContinuousOn;
	unsigned short BuzzerOnTime;
} TBuzzerInfo;

typedef	struct
{
	int	EyeProtectionModeEnabled;
	int	LEDOnTime;
	int	LEDOffDelay;
} TLEDInfo;

typedef	struct
{
	int	PressureAlarmLevel;
	int	VacuumAlarmLevel1;
	int	VacuumAlarmLevel2;
	int	TemperatureAlarmLevel1;
	int	TemperatureAlarmLevel2;
	int	TemperatureAlarmLevel3;
	int	reserved[2];
} TAlarmSetupInfo;

typedef	struct
{
	int	MachineDataVersion;
	int	MachineMode;
	int	PC_Power_Mode;
	TMachineCaptureInfo	MachineCaptureInfo;
	TEjectorInfo EjectorInfo;
	TVibrationFeederInfo VFInfo;
	unsigned int SensorIntervalA;
	unsigned int SensorIntervalB;
	TInterlockInfo InterlockInfo;
	TBuzzerInfo	BuzzerInfo;
	TLEDInfo LEDControlInfo;
	double ZeroPositionValue[MAX_STEP_MOTOR_COUNT];
	TServoMotorData	ServoMotorData[MAX_SERVO_MOTOR_COUNT];
	TAlarmSetupInfo	AlarmSetupInfo;
        unsigned int HopperEmptyEnable;
        unsigned int reserved[10];
    // khd1994 - HCB TCP ּ  Ʈȣ
    unsigned short nHCB_TcpPort;
    char     szHCB_IpAddr[32];
} TMachineSetupData;

typedef	struct
{
	int	Enabled;
	int	DustBlower1Interval;
	int	DustBlower2Interval;
	int	DustBlower3Interval;
	int	DustBlower4Interval;
	int	DustBlower5Interval;
	int	DustBlower1Delay;
	int	DustBlower2Delay;
	int	DustBlower3Delay;
	int	DustBlower4Delay;
	int	DustBlower5Delay;
	int	DustBlower1BlowTime;
	int	DustBlower2BlowTime;
	int	DustBlower3BlowTime;
	int	DustBlower4BlowTime;
	int	DustBlower5BlowTime;
} TUserMachineEnv;

typedef	struct
{
	int	IlluminatorMask[SYSTEM_MACHINE_CAPTURE_COUNT];
	float TabletLength;
	int	SuctionDiskSpeed;
	int	StudiedTabletSensorLength;
  int CaptureOption;
} TMachineCaptureSetupData;

typedef	struct
{
	int	CountingMode;
	unsigned int Counter;
	unsigned int SubCounter[2];
	unsigned int ElapsedTime;
	float CPS;
	int	CPM;
	int	IndexTable[TC_TABLE_CAPACITY];
	int	OffInterval[TC_TABLE_CAPACITY];
	int	OnInterval[TC_TABLE_CAPACITY];
	int	CurrentTableIndex;
} TTabletCounter;

typedef	struct
{
	unsigned int Counter;
	unsigned int ElapsedTime;
	unsigned int LastCheckingTime;
	unsigned int ElapsedTimeInterval;
	unsigned int IntervalCounter;
	int	CPM;
} TSimpleTabletCounter;

typedef	struct
{
	int	TestCount;
	unsigned char OPList[MAX_OP_TEST_COUNT];
	unsigned char IsPhysicalPort[MAX_OP_TEST_COUNT];
	int	DelayIntervalList[MAX_OP_TEST_COUNT];
	int	OnIntervalList[MAX_OP_TEST_COUNT];
	int	OffIntervalList[MAX_OP_TEST_COUNT];
} TOPTestData;

typedef	struct
{
	short TemperatureData[SYSTEM_MAX_THERMOMETER_COUNT];
	short HumidityData[SYSTEM_MAX_THERMOMETER_COUNT];
	short Pressure[SYSTEM_MAX_PRESSURE_METER_COUNT];
	short DotPos[SYSTEM_MAX_PRESSURE_METER_COUNT];
	short InverterRPM[SYSTEM_MAX_INVERTER_COUNT];
} TMonitoringInfo;

typedef	struct
{
	unsigned int WrongAddressCount[RS485_UNIT_COUNT];
	unsigned int CRCErrorCount[RS485_UNIT_COUNT];
	unsigned int SizeErrorCount[RS485_UNIT_COUNT];
	unsigned int ReceiveTOCount[RS485_UNIT_COUNT];
	unsigned int TXCount[RS485_UNIT_COUNT];
} TRS485DebugInfo;

typedef struct
{
	int	TabletNumber;
	int	InspectionResult;
	int	State;
	unsigned int Sensor1Time;
	unsigned int CaptureIntTime;
	unsigned int EstimatedSensor2Time;
	int	Sensor1Length;
	int	IsLEDOn[SYSTEM_MACHINE_CAPTURE_COUNT];
} THCBDisk1TabletUnit;

typedef	struct
{
	int	TabletNumber;
	int	InspectionResult;
	int	InspectionResult_SPB[SYSTEM_SPB_MAX_COUNT];
	int	State;
	unsigned int Sensor1Time;
	unsigned int CaptureIntTime;
	unsigned int EstimatedSensor2Time;
	unsigned int Sensor2Time;
	unsigned int EstimatedSensor3Time;
	unsigned int Sensor3Time;
	int	Sensor1Length;
	int	Sensor2Length;
	int	Sensor3Length;
	int	IsLEDOn[SYSTEM_MACHINE_CAPTURE_COUNT];
	unsigned int DefectEjectorTime;
	unsigned int UnInsEjectorTime;
	int	Ejection;
	int	EjectionCheck;
} THCBDisk2TabletUnit;

typedef	struct
{
	unsigned int Sensor3Time;
	int	State;
	int	Sensor3Length;
} THCBCounterTabletUnit;
typedef	struct
{
	THCBDisk1TabletUnit	Disk1TabletList[HCB_TABLET_LIST_COUNT];
	THCBDisk2TabletUnit	Disk2TabletList[HCB_TABLET_LIST_COUNT];
	THCBCounterTabletUnit CounterTabletList[HCB_TABLET_LIST_COUNT];

	int	CurrentTabletNumber;

	int	CurrentSensor1ListIndex;
	int	CurrentSensor2ListIndex;
	int	CurrentSensor3ListIndex;
	int	CurrentRelatedDisk1TabletListIndex;
	int	CurrentRelatedDisk2TabletListIndex;

	int	CurrentInt1ListIndex;
	int	CurrentInt2ListIndex;

	int	CurrentCapture1ListIndex;
	int	CurrentCapture2ListIndex;

	int	PollingResultTabletIndex;
	int	PollingBlowTabletIndex;

	int	CounterCheckListIndex;

	unsigned int CounterSensorInsertTimeList[HCB_TABLET_LIST_COUNT];
	unsigned int CounterSensorInsertLengthList[HCB_TABLET_LIST_COUNT];
} TTabletInfo;

typedef	struct
{
	int	Disk1TabletCount;
	int	Disk2TabletCount;
	int	TotalTabletCount;
	int	GoodTabletCount;
	int	DefectTabletCount;
	int	UnInsTabletCount;
  	int	UnPrintTabletCount;
	int	PrintMisMatchCount;
	int	SPBProcessingNCTabletCount;
	int	SPBTOTabletCount;
	int	SPBUnInsTabletCount;
	int	DisappearedTabletCount;
	int	InsertedTabletCount;
	int	LateTabletCount;
	int	EarlyTabletCount;
	int	ClosedTabletCount;
	int	WrongNumberTabletCount;
	int	NumberUndefTabletCount;
	int	CaptureNotReadyTabletCount;
	int	BufferFullTabletCount;
	int	CaptureTimoutTabletCount;
	int	ProcessingTimoutTabletCount;
	int	CPBFullTabletCount;
	int	ProcessingErrorTabletCount;
	int	UnInsTabletPositionCount;
	int	UnInsBrightnessDropCount;
	int	UnInsBrightnessChaseCount;
	int	Sensor1MisFeedingTabletCount;
	int	Sensor2MisFeedingTabletCount;
	int	Sensor1MultiTabletCount;
	int	Sensor2MultiTabletCount;
	int	UnIntendedUninsTabletCount;
	int	CounterSensorTabletCount;
	int	MisejectActiveCount;
	int	GoodTabletLostCount;
	int	MisejectTabletInsertCount;
	int	MisejectDefectTabletCount;
	int	MisejectUnInsTabletCount;
	int	FRMismatchTabletCount;
    int TabletDropIndex; //2й  ȣ //HCB -> UI  UI  ް ִ  ǥ ϱ ؼ.
} TTabletInspectInfo;

typedef	struct
{
    int	InspectionMode;
    int	SPBMask;
    float TabletLength;
    int	MachineStopActivated;
    int	MachineStopDefectRatio;
    int	MachineStopUnInsRatio;
    int	CameraMapInfo_SPB[SYSTEM_TOTAL_CAMERA_COUNT];
    int	CameraMapInfo_CAM[SYSTEM_TOTAL_CAMERA_COUNT];
    int	CheckUnPrint;
    int	CheckFrontRear;
    int	InspectionNCAsDefect;
    int	DesiredGPCount;
    int	MachineStopDPCount;
    int	MachineStopUPCount;
    int	InspectionID;
    int	SuctionDiskSpeed;
    int	StudiedTabletSensor1Length;
    int	StudiedTabletSensor2Length;
    int	StudiedTabletSensor3Length;
    int	StudiedSensorIntervalA;
    int	StudiedSensorIntervalB;
    unsigned int UnPrintInspectionType;
    int CaptureMode;

    /*********  Eject	Information	*********/
    int EjectMode;
    int BlowInterval;
    int BlowStart;
    int BlowLength;
    int UnInsBlowCheck;
    int DHSpecialInsCheckbox; 
    int DHSpecialInsCount[6];
    int DHCountCheck[6];
    int DistributorCheck;            // 2й  
    int DistributorGoodTabletCount1; // 2й ǰ īƮ 1
    int DistributorGoodTabletCount2; // 2й ǰ īƮ 2
    int CloseTabletCheckbox;         // .
    int CloseTabletLength;			 // .
    int StartType;					 // 2й ˻ .(Ʈ)
} THCBInspectionOption;

typedef	struct
{
	int	TabletNumber;
	int	Result;
} TInspectionResultTableUnit;

typedef	struct
{
	TInspectionResultTableUnit Table[RESULT_TABLE_SIZE];
	int	CurrentIndex;
} TInspectionResultTable;

typedef	struct
{
	int	RangeLeft[SYSTEM_TOTAL_CAMERA_COUNT];
	int	RangeTop[SYSTEM_TOTAL_CAMERA_COUNT];
	int	RangeRight[SYSTEM_TOTAL_CAMERA_COUNT];
	int	RangeBottom[SYSTEM_TOTAL_CAMERA_COUNT];
} TTabletCaptureSetupData;

typedef	struct
{
	int	ImageCount;
	unsigned char ImageStatus[2048];
} TProcessingImageBufferData;

typedef	struct
{
	unsigned int CaptureMode;
	unsigned char CameraMask;
	unsigned char CaptureKind;
	unsigned char dummy[2];
	unsigned short ShutterSpeed[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short ShutterDelay[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short CaptureStartX;
	unsigned short CaptureLengthX;
	unsigned short CaptureStartY;
	unsigned short CaptureLengthY;
	int	FrameBufferCount;
	int	FrameHeight;
} TCaptureCommandParam; // For SELMA200, Rev by moon.

typedef	struct
{
	unsigned int CaptureType;		// single, multi
	unsigned int CaptureMode;
	unsigned char CameraMask;
	unsigned char ContainParams;
	unsigned char dummy[2];
	unsigned short ShutterSpeed[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short ShutterDelay[SYSTEM_SPB_CAMERA_MAX_COUNT]; // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	unsigned short TriggerFreq[SYSTEM_SPB_CAMERA_MAX_COUNT];  // (20180208) [4] -> [SYSTEM_SPB_CAMERA_MAX_COUNT]
	int	FrameBufferCount;
} TCaptureSetupData; // For SELMA200, Rev by moon.

typedef	struct
{
	int	State;
	int	Result;
	int	ImageFrameIndex;
	int	ResultReported;
	unsigned char *CaptureImagePtr[SYSTEM_SPB_CAMERA_COUNT];
	int	CalibCaptureFrameIndex[SYSTEM_SPB_CAMERA_COUNT];
	int	CaptureStatus[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int TabletNumber;
	unsigned int CaptureIntTime;
	unsigned int ProcessingStartTime[SYSTEM_SPB_CAMERA_COUNT];
	int	InspectionState[SYSTEM_SPB_CAMERA_COUNT];
	int	ProcessingResult[SYSTEM_SPB_CAMERA_COUNT];
	int	PrintResult[SYSTEM_SPB_CAMERA_COUNT];
	int	PrintType[SYSTEM_SPB_CAMERA_COUNT];
	int	ThickErrorSW[SYSTEM_SPB_CAMERA_COUNT];
	int	Front_Rear[SYSTEM_SPB_CAMERA_COUNT];
} TSPBTabletUnit;

typedef	struct
{
	TSPBTabletUnit TabletList[SPB_TABLET_LIST_COUNT];
	unsigned int ExpectedNextTabletNumber;
	int	NextCaptureListIndex;
	int	FindingBufferListIndex;
	int	NumberingCaptureListIndex;
	int	PollingCaptureListIndex;
	int	PollingCaptureEndListIndex[SYSTEM_SPB_CAMERA_COUNT];
	int	PollingCaptureAllEndListIndex;
	int	ProcessingTabletListIndex[SYSTEM_SPB_CAMERA_COUNT];
	int	ProcessingAllTabletListIndex;
	int	ProcessingResultListIndex[SYSTEM_SPB_CAMERA_COUNT];
	int	ProcessingResultCheckingListIndex;
	int	ProcessingResultReportingListIndex;
	int	DiscBaseSpeed[2];
	int	DiscTargetSpeed[2];
	int	CaptureMode;
	int	ProcessingMode;
	int	TabletNumberRequestOn;
	int	TabletNumberReceived;
	unsigned int ReceivedTabletNumber;
} TSPBTabletProcessInfo;

typedef	struct
{
	int	CompleteCount;
	unsigned char ProcessingResult[SPB_PROCESSING_RESULT_COUNT];
	int	ProcessedTabletNumber[SPB_PROCESSING_RESULT_COUNT];
} TSPBProcessingResultData;

typedef	struct
{
	int	TabletNumber;
	unsigned int CaptureStartTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int CaptureEndTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ImageSendStartTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ProcessingStartTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int BeforePollingTime[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int ProcessingEndTime[SYSTEM_SPB_CAMERA_COUNT];
	int	ProcessingCPB[SYSTEM_SPB_CAMERA_COUNT];
	unsigned int CompleteTime;
} TProcessingTime;

typedef	struct
{
	char SetupKind;
	char SetupStep;
	char AvailCPBCount;
	char SetupCPBCount;
	char FailCPBCount;
	char CurrentCPBIndex;
	char dummy[2];
	char CPBStep[SYSTEM_CPB_MAX_COUNT];
	unsigned int WaitingStartTime;
} TSPBProcessingSetupInfo;

typedef	struct
{
	short VFSpeedList[VFINFO_LIST_COUNT];
	short VFMaxSpeedList[VFINFO_LIST_COUNT];
	short VFLimitSpeedList[VFINFO_LIST_COUNT];
	short VFSensor1RatioList[VFINFO_LIST_COUNT];
	short VFSensor2RatioList[VFINFO_LIST_COUNT];
 	short NowSpeedList[VFINFO_LIST_COUNT];
	short AverageSpeedList[VFINFO_LIST_COUNT];
	short AverageSensor1RatioList[VFINFO_LIST_COUNT];
	short AverageSensor2RatioList[VFINFO_LIST_COUNT];
	int	CurrentListIndex;
	int	SetRatio1;
	int	SetRatio2;
	int	Sensor1ON_NowRatio;
	int	Sensor2ON_NowRatio;
	int	test;
	int	test1;
	int	test2;
	int	test3;
	int	VFMode;
	int	BeforeSensor1Ratio;
	int	BeforeSensor2Ratio;
	int	AverageSensor1Ratio;
	int	AverageSensor2Ratio;
	unsigned short NowSpeed;
} TVibratorInfo;

typedef	struct
{
 	int	Change_Ratio;
} TChul_VFData;

typedef	struct
{
	int	DataValid;
	int	InspectionID;
	TTabletInspectInfo InspectionInfo;
} TTerminationInfo;

typedef	struct
{
	int	DefectExists;
	int	DefectTabletNumber;
	int	DefectCameraMask[SYSTEM_SPB_CAMERA_COUNT];
} TDefectImageInfo;

typedef	struct
{
	int	ProcessingTimeList[CPB_PROCESSING_TIME_LIST_COUNT];

} TCPBProcessingInfo;

typedef	struct
{
	unsigned short Version;
	unsigned short PartNumber;
	unsigned short Manufacturer;
	unsigned char InfoValid;
	unsigned char IsC64PlusDevice;
} TCPBDeviceInfo;

typedef	struct
{
	int	Length;
	char Data[4092];
} TRangerCameraParamData;

typedef	struct
{
	int	CurrentIndex;
	unsigned int CurrentTime;
	unsigned int Time[IDLE_PROCESS_LIST_COUNT];
	unsigned int TimeCounter[IDLE_PROCESS_LIST_COUNT];
	unsigned int Min50usCount[IDLE_PROCESS_LIST_COUNT];
	unsigned int Max50usCount[IDLE_PROCESS_LIST_COUNT];
} TIdleProcessData;

typedef	struct
{
	unsigned char Activated;
	unsigned char InspectionStopBuzzerOn;
	unsigned char InspectionStopMachinePowerOff;
	unsigned char TimerEnabled;
	unsigned int MachinePowerOffDelay;
	unsigned int BuzzerOnTime;
	unsigned int InspectionStopTimer;
} TUnmanedOperationData;

typedef	struct
{
	unsigned short 	troubleBoard;
	unsigned short 	type;
	unsigned int	time;
	unsigned int 	code;							/* error code */
	unsigned int 	value[ERROR_VALUE_MAX_SIZE];
} TErrorUnit;

typedef struct{
	unsigned char Enabled;
	unsigned char IsDown;
	unsigned char Step;
}TVirtualCPBStatus;


// ROI, Shutter, Gain, Threshold ǰ  ٲ Ǵ 
//---------------------------------------------------------------------------
// Camera Packet
#define CAMERA_DATA_HEADER  0xA1

#define CAMERA_DATA_CMD_BINNING_MODE_L          0x6C // Binning  
#define CAMERA_DATA_CMD_BINNING_MODE_H          0x20

#define CAMERA_DATA_CMD_SUBSAMPLING_MODE_L      0x6C // Sub Sampling  
#define CAMERA_DATA_CMD_SUBSAMPLING_MODE_H      0x22

#define CAMERA_DATA_CMD_ROI_L                   0x6C // ROI 
#define CAMERA_DATA_CMD_ROI_H                   0x26 // R|W Length δٸ (PC To SPB)

#define CAMERA_DATA_CMD_SHUTTER_L               0x6C // Shutter Speed 
#define CAMERA_DATA_CMD_SHUTTER_H               0x46 // R|W Length δٸ (PC To SPB)

#define CAMERA_DATA_CMD_WB_L                    0x6C // White Balance 
#define CAMERA_DATA_CMD_WB_H                    0x70 // R|W Length δٸ (PC To SPB)

#define CAMERA_DATA_CMD_A_GAIN_L                0x6C // Analog Gain
#define CAMERA_DATA_CMD_A_GAIN_H                0xCC

#define CAMERA_DATA_CMD_D_GAIN_L                0x6C // Digital Gain
#define CAMERA_DATA_CMD_D_GAIN_H                0xC2 // R|W Length δٸ (PC To SPB)

#define CAMERA_DATA_CMD_TR_L                    0x6C // IMAGE TRANSFER SPEED
#define CAMERA_DATA_CMD_TR_H                    0x44

#define CAMERA_DATA_CMD_3D_IMAGE_MODE_L         0x6C // 3D ī޶  
#define CAMERA_DATA_CMD_3D_IMAGE_MODE_H         0x74

#define CAMERA_DATA_CMD_THR_L                   0xFF //
#define CAMERA_DATA_CMD_THR_H                   0xFF

//---------------------------------------------------------------------------
// ߰Ǿ 
#define CAMERA_DATA_CMD_IMG_FORMAT_L            0x6C // 1ȼ 10bit or 8bit ó
#define CAMERA_DATA_CMD_IMG_FORMAT_H            0x18

#define CAMERA_DATA_CMD_TRIGGER_MODE_L          0x6C
#define CAMERA_DATA_CMD_TRIGGER_MODE_H          0xC0

#define CAMERA_DATA_FLASH_WRITE_L               0x6C
#define CAMERA_DATA_FLASH_WRITE_H               0x10

//---------------------------------------------------------------------------
#define MAX_2D_CAMERA_DATA_INDEX  17
#define MAX_3D_CAMERA_DATA_INDEX  10

#define FULL_SCALE_IMAGE_WIDTH  1280
#define FULL_SCALE_IMAGE_HEIGHT 1024


typedef enum
{
  ECAMERA_PARAM_2D_BINNING_MODE,
  ECAMERA_PARAM_2D_SAMPLING_MODE,
  ECAMERA_PARAM_2D_ROI_START_X,
  ECAMERA_PARAM_2D_ROI_END_X,
  ECAMERA_PARAM_2D_ROI_START_Y,
  ECAMERA_PARAM_2D_ROI_END_Y,
  ECAMERA_PARAM_2D_SHUTTER_TIME,
  ECAMERA_PARAM_2D_ANALOG_GAIN,
  ECAMERA_PARAM_2D_DIGIT_GAIN1,
  ECAMERA_PARAM_2D_DIGIT_GAIN2,
  ECAMERA_PARAM_2D_WHITE_BALANCE_B,
  ECAMERA_PARAM_2D_WHITE_BALANCE_G1,
  ECAMERA_PARAM_2D_WHITE_BALANCE_G2,
  ECAMERA_PARAM_2D_WHITE_BALANCE_R,
  ECAMERA_PARAM_2D_DATA_TRANSFER_RATE,
  ECAMERA_PARAM_2D_IMAGE_FORMAT,
  ECAMERA_PARAM_2D_TRIGGER_MODE
} ETwoDCameraParameter;

typedef enum
{
  ECAMERA_PARAM_3D_BINNING_MODE,
  ECAMERA_PARAM_3D_ROI_START_X,
  ECAMERA_PARAM_3D_ROI_END_X,
  ECAMERA_PARAM_3D_ROI_START_Y,
  ECAMERA_PARAM_3D_ROI_END_Y,
  ECAMERA_PARAM_3D_SHUTTER_TIME,
  ECAMERA_PARAM_3D_THRESHOLD,
  ECAMERA_PARAM_3D_ANALOG_GAIN,
  ECAMERA_PARAM_3D_IMAGE_MODE,
  ECAMERA_PARAM_3D_TRIGGER_MODE
} EThreeDCameraParameter;

/*
typedef struct
{
  //int Data[MAX_2D_CAMERA_DATA_INDEX];

  // ̹  
  int BinningMode;
  int SubSamplingMode;

  // ɿ 
  // ⺻
  int ROIStartX;  // 0 ~ 159 (1280 / 8 = 160)
  int ROIEndX;    // 0 ~ 159 (1280 / 8 = 160)
  int ROIStartY;  // 0 ~ 1023
  int ROIEndY;    // 0 ~ 1023

  // ̹ 
  int ShutterTime;

  int AnalogCameraGain;
  int DigitalCameraGain1;
  int DigitalCameraGain2;

  //  
  int WhiteBalance[3]; // BGR

  // SPB - CAMERA  ̹  ӵ
  int ImageTransferRate; // ̹ ۼӵ 1/4  ٿִ °

} TTwoDCameraInformation;
*/

typedef struct
{
  // ̹  
  int BiningMode;

  // ROI
  int ROIStartX;  // 0 ~ 159 (1280 / 8 = 160)
  int ROIWidth;   // 640 (640 / 8)
  int ROIStartY;  // 0 ~ 1023
  int ROIHeight;  // 128

  // Profiling Image or One Frame Image
  int ImageOutputMode;

  // 3D ī޶  Open ð
  int ExposureTime;

  //   
  int Thresold3D;
  int AnalogCameraGain;
  int TriggerMode;

  int LineScanTrigerFulse;// ...

} TThreeDCameraDefaultInformation;

#define CAMERA_WRITE_MASK_SH            0x01
#define CAMERA_WRITE_MASK_TH            0x02
#define CAMERA_WRITE_MASK_ROI           0x04

#define UNIT_CONVERT_CONSTANT_VALUE_FOR_3D 16.99f
#define ROW_COUNT_FOR_HIGH_SPEED  90 // 80 -> 90, 20171121 ̹  ߻
#define SUB_ROI_COUNT             12
#define HARD_TILTING_STD_TABLET_LENGTH  15.0f

typedef struct
{
  int ShutterSpeed;

  int Threshold;

  int ROIStartX;
  int ROIEndX;
  int ROIStartY;
  int ROIEndY;

  int TrigFreq;
} TVariableCameraInformation;

typedef struct
{
  int StartX;
  int EndX;
  int StartY;
  int EndY;
} TROIInfo;

typedef struct
{
  int BColorInfo;
  int GColorInfo;
  int RColorInfo;

} TWhiteBalanceInfo;


/************************************************************************************/
/* Common Function																	*/
/************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

unsigned int CheckSum(unsigned int *src, unsigned int len);
unsigned int ImageCheckSum(unsigned char* src, int left, int top, int width, int height, int size);
int	SizeOfWord(int size);

#ifdef __cplusplus
}
#endif

#endif
